<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\ApiController;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class AuthController extends ApiController
{
    function login(Request $request)
    {

        $request->validate([
            'email' => 'required|email',
            'password' => 'required'
        ]);

        $data = $request->only(['email', 'password']);

        $user = User::where('email', $data['email'])->first();


        if ($user && Hash::check($data['password'], $user->password)) {
            $accessTokenObject = $user->createToken('authToken');
            $accessToken = $accessTokenObject->plainTextToken;

            return
                [
                    'status' => 'success',
                    'accessToken' => $accessToken,
                ];


        } else {

            return (['status' => 'failed', 'message' => 'Email or Password is incorrect']);
        }
    }

    /*
     * Registration System
     *
     */

    function register()
    {
        $validator = Validator::make(\request()->all(), [
            'email' => 'required|email|unique:users',
            'username' => 'required|username',
            'password' => 'required|min:8',
            'name' => 'required|string'
        ]);

        //validation error

        if ($validator->fails()) {
            return $this->validationError($validator->errors()->all());
        }

        //get user data

        $userData = \request()->only(['name', 'email', 'username', 'password']);

        //use transaction

        //complete registration

        DB::beginTransaction();

        try {

            $business = new Business();
            $business->name = 'My Business';

            //user instance

            $user = new User();

            $user->name = $userData['name'];
            $user->email = $userData['email'];
            $user->password = bcrypt($userData['password']);
            $user->username = $userData['username'];

            $user->save();

            //set owner id and save business

            $business->owner_id = $user->id;

            $business->save();

            //update business id of user

            $user->business_id = $business->id;
            $user->save();

            //Assign super admin role

            $role = Role::where('name', 'Admin#' . $business->id)
                ->where('guard_name', '=', 'api')
                ->orWhere('guard_name', '=', 'sanctum')
                ->first();

            if (empty($role) || !$role) {
                $role = Role::create(['name' => 'Admin#' . $business->id, 'business_id' => $business->id]);
            }
            //now assign trial periods for new user

            //find trial package

            $package = Package::where('name', '=', 'Trial')->first();

            if (!$package && empty($package)) {
                //create Trial Package
                $package = Package::create([
                    'name' => 'Trial',
                    'validity' => 30,
                    'description' => 'Trial Package'
                ]);
            }

            Subscription::create([
                'business_id' => $business->id,
                'package_id' => $package->id,
                'start_time' => now(),
                'end_time' => now()->addDays($package->validity),
            ]);

            $user->assignRole($role);

            DB::commit();

            return $this->respondWithSuccess('Registration Successful');

        } catch (\Exception $exception) {
            return $this->handleException($exception);
        }

    }

    function getUser()
    {

        $user = \auth()->user();

        return response($user);
    }

    function logout(): \Illuminate\Http\JsonResponse
    {
        $message = \auth()->logout();

        return $this->respondWithSuccess($message);
    }
}
