<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\ApiController;
use App\Models\BlogCategory;
use Illuminate\Http\Request;

class BlogCategoryController extends ApiController
{
    function index()
    {
        $data = BlogCategory::all();

        return $this->respondWithData($data);
    }

    function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:100',
        ]);

        $data = $request->only(['name']);

        $id = $request->input('id');

        if ($id) {
            $certificate = BlogCategory::findOrFail($id);
            $certificate->update($data);
            return $this->respondWithSuccess('Blog Category updated successfully');
        }

        BlogCategory::create($data);

        return $this->respondWithSuccess('Blog Category created successfully');

    }

    function destroy($id, Request $request)
    {
        $certificate = BlogCategory::findOrFail($id);
        $certificate->delete();

        return response()->json([
            'status' => 'success',
            'message' => 'ISO Certificate deleted successfully',
        ]);
    }

    function toggleStatus($id)
    {
        $certificate = BlogCategory::find($id);
        $certificate->status = !$certificate->status;
        $certificate->save();

        return response()->json([
            'status' => 'success',
            'message' => "Updated Successfully"
        ]);

    }

}
