<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\Controller;
use App\Models\Blog;
use Carbon\Carbon;
use Illuminate\Http\Request;

class BlogController extends ApiController
{
    function index(Request $request)
    {
        $query = Blog::with(['category', 'file']);
        $blog_category_id = $request->blog_category_id;

        if ($blog_category_id) {
            $query->where('blog_category_id', $blog_category_id);
        }

        $blogs = $query->get()->map(function ($item) {
            $item->passed_time = Carbon::parse($item->date)->diffForHumans();
            return $item;
        });

        return $this->respondWithData($blogs);
    }

    function store(Request $request)
    {
        $request->validate([
            'date' => 'required|string',
            'title' => 'required|string',
            'short_description' => 'required|string',
            'blog_category_id' => 'required|numeric',
            'content' => 'string',
            'file_id' => 'nullable|numeric:',
        ]);

        $id = $request->id;

        $message = 'Blog created successfully';

        if ($id) {
            $blog = Blog::findOrFail($id);
            $message = 'Expense updated successfully';
        } else {
            $blog = new Blog();
        }

        $data = $request->only([
            'date', 'title', 'blog_category_id',
            'content', 'file_id', 'short_description'
        ]);

        $data['user_id'] = auth()->id();

        $blog->fill($data);
        $blog->save();

        return $this->respondWithSuccess($message);

    }

    function update()
    {

    }

    function show($id)
    {
        $expense = Blog::with(['file'])->findOrFail($id);

        return response()->json($expense);
    }

    function destroy($id)
    {
        $expense = Blog::findOrFail($id);
        $expense->delete();

        return $this->respondWithSuccess('Expense deleted successfully');
    }

}
