<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\Controller;
use App\Models\Project;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ProjectController extends ApiController
{
    function index(Request $request)
    {
        $query = Project::with(['serviceType', 'file']);
        $project_category_id = $request->service_type_id;

        if ($project_category_id) {
            $query->where('project_category_id', $project_category_id);
        }

        $projects = $query->get()->map(function ($item) {
            $item->passed_time = Carbon::parse($item->date)->diffForHumans();
            return $item;
        });

        return $this->respondWithData($projects);
    }

    function store(Request $request)
    {
        $request->validate([
            'date' => 'required|string',
            'title' => 'required|string',
            'service_type_id' => 'required|numeric',
            'content' => 'nullable|string',
            'file_id' => 'nullable|numeric:',
            'summary' => 'required|string',
            'challenge' => 'string',
            'result' => 'string',
            'screenshots' => 'nullable|array'
        ]);

        $id = $request->id;

        $message = 'Project created successfully';

        if ($id) {
            $project = Project::findOrFail($id);
            $message = 'Project updated successfully';
        } else {
            $project = new Project();
        }

        $data = $request->only([
            'date', 'title', 'service_type_id',
            'content', 'file_id', 'summary', 'screenshots',
            'challenge', 'result', 'client',
        ]);

        $project->fill($data);
        $project->save();

        return $this->respondWithSuccess($message);

    }

    function update()
    {

    }

    function show($id)
    {
        $expense = Project::with(['file'])->findOrFail($id);

        return response()->json($expense);
    }

    function destroy($id)
    {
        $expense = Project::findOrFail($id);
        $expense->delete();

        return $this->respondWithSuccess('Expense deleted successfully');
    }

}
