<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\ApiController;
use App\Models\ServiceType;
use Illuminate\Http\Request;

class ServiceTypeController extends ApiController
{
    function index()
    {
        $data = ServiceType::all();

        return $this->respondWithData($data);
    }

    function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:100',
        ]);

        $data = $request->only(['name']);

        $id = $request->input('id');

        if ($id) {
            $certificate = ServiceType::findOrFail($id);
            $certificate->update($data);
            return $this->respondWithSuccess('Service Type updated successfully');
        }

        ServiceType::create($data);

        return $this->respondWithSuccess('Service Type created successfully');

    }

    function destroy($id, Request $request)
    {
        $certificate = ServiceType::findOrFail($id);
        $certificate->delete();

        return response()->json([
            'status' => 'success',
            'message' => 'ISO Certificate deleted successfully',
        ]);
    }

    function toggleStatus($id)
    {
        $certificate = ServiceType::find($id);
        $certificate->status = !$certificate->status;
        $certificate->save();

        return response()->json([
            'status' => 'success',
            'message' => "Updated Successfully"
        ]);

    }

}
