<?php

namespace App\Http\Controllers;

use App\Models\Auditor;
use App\Models\Client;
use App\Models\BlogCategory;
use App\Models\IsoCertification;
use App\Models\ServiceType;
use Illuminate\Http\Request;

class CommonController extends Controller
{
    function getDropdownData(Request $request)
    {
        $model = $request->model;

        if ($model == null) {
            return response()->json([
                'status' => 'failed',
                'message' => 'Model is required'
            ]);
        }

        $data = [];
        if ($model == 'blog-category') {
           $data = BlogCategory::select('id', 'name as name')->get();
        }

        if ($model == 'service-type') {
            $data = ServiceType::select('id', 'name as name')->get();
        }

        return response()->json($data);
    }

    function getHomeData(Request $request){
        $data = [
            'client_count' => Client::count(),
            'certificate_count' => IsoCertification::count(),
        ];
        return response()->json($data);
    }

}

