<?php

namespace App\Http\Controllers;

use App\Models\File;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class FileController extends Controller
{
    function index()
    {
        $files = File::query();
        $sort = strtolower(request('sort', 'latest'));

        $search = request('search', '');

        if ($search) {
            $files = $files->where('name', 'like', '%' . $search . '%');
        }

        if ($sort == 'latest') {
            $files = $files->latest();
        }
        if ($sort == 'oldest') {
            $files = $files->oldest();
        }
        if ($sort == 'smallest') {
            $files = $files->orderBy('size', 'asc');
        }
        if ($sort == 'largest') {
            $files = $files->orderBy('size', 'desc');
        }

        $files = $files->paginate(10);

        return response()->json($files);
    }

    function store(Request $request)
    {
        $request->validate([
            'file' => 'required|file|mimes:jpeg,png,jpg,webp,pdf |max:5120',
        ]);

        $file = $request->file('file');
        $name = Str::uuid() . '.' . $file->getClientOriginalExtension();
        $path = '/uploads/' . $name;

        $extension = $file->getClientOriginalExtension();

        if (in_array($extension, ['jpg', 'png', 'jpeg', 'svg'])) {
            $type = 'image';
        }


        File::create([
            'name' => $name,
            'path' => $path,
            'type' => $type,
            'size' => $file->getSize(),
        ]);

        $file->move(public_path('uploads'), $name);

        return response()->json([
            'status' => 'success',
            'message' => 'File uploaded successfully',
            'file' => $path,
        ]);

    }

    function destroy(Request $request)
    {
        $ids = $request->ids;

        //remove from storage

        //unlink(public_path($request->path));

        File::whereIn('id', $ids)->delete();

        return response()->json([
            'status' => 'success',
            'message' => 'Files deleted successfully',
        ]);

    }

}
