<?php

namespace App\Http\Controllers;

use App\Models\Blog;
use App\Models\BlogCategory;
use App\Models\BlogVisitor;
use App\Models\Project;
use App\Models\ServiceType;
use Illuminate\Http\Request;

class WebsiteController extends Controller
{
    function blogs(Request $request)
    {
        $query = Blog::latest();

        $limit = $request->input('limit', 10);
        $query = $query->take($limit);

        $categoryId = $request->input('category_id', null);

        if ($categoryId) {
            $query->where('category_id', $categoryId);
        }

        $page = $request->input('page', null);
        if ($page) {
            $blogs = $query->paginate($limit, ['*'], 'page', $page);
        } else {
            $blogs = $query->get();
        }
        return response()->json($blogs);

    }

    function blogDetails($id)
    {
        $blog = Blog::with(['category', 'file'])->findOrFail($id);
        //add related blogs
        $blog->related_blogs = Blog::where('blog_category_id', $blog->blog_category_id)
            ->take(5)->get();

        $nextBlog = Blog::find($blog->id + 1);
        $blog->next_blog = $nextBlog;

        //count visitor

        $data = [
         'ip' => \request()->ip(),
         'blog_id' => $blog->id,
        ];

        $alreadyVisited = BlogVisitor::where('ip', $data['ip'])
            ->where('blog_id',$blog->id)
            ->first();

        if(!$alreadyVisited){
            BlogVisitor::create($data);
        }

        return response()->json($blog);
    }

    function getRelatedBlogs($id)
    {

        $blog = Blog::find($id);
        $relatedBlogs = Blog::where('blog_category_id', $blog->category_id)->where('id', '!=', $id)
            ->take(5)->get();
        return response()->json($relatedBlogs);

    }

    function categories()
    {
        $categories = BlogCategory::withCount('blogs')->get();

        return response()->json($categories);
    }

    function projects(Request $request)
    {
        $query = Project::latest();

        $limit = $request->input('limit', 10);
        $query = $query->take($limit);

        $serviceTypeId = $request->input('service_type_id', null);

        if ($serviceTypeId) {
            $query->where('service_type_id', $serviceTypeId);
        }

        $page = $request->input('page', null);
        if ($page) {
            $blogs = $query->paginate($limit, ['*'], 'page', $page);
        } else {
            $blogs = $query->get();
        }
        return response()->json($blogs);

    }

    function projectDetails($id)
    {
        $project = Project::with(['serviceType', 'file'])->findOrFail($id);

        $project->next_project = Project::find($project->id + 1);

        $project->related_projects = Project::where('service_type_id', $project->service_type_id)
            ->take(5)->get();

        return response()->json($project);
    }

    function services()
    {
        $serviceTypes = ServiceType::withCount('projects')->get();

        return response()->json($serviceTypes);
    }

}
