<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Blog extends Model
{
    protected $guarded = ['id'];

    protected $appends = ['image_url', 'username', 'passed_time', 'visitor_count'];

    public function file()
    {
        return $this->belongsTo(File::class, 'file_id');
    }

    public function category()
    {
        return $this->belongsTo(BlogCategory::class, 'blog_category_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function getImageUrlAttribute()
    {
        return $this->file ? asset($this->file->path) : null;
    }

    public function getUsernameAttribute()
    {
        return $this->user ? $this->user->name : null;
    }

    public function getPassedTimeAttribute()
    {
        return $this->created_at->diffForHumans();
    }

    function visitors()
    {
        return $this->hasMany(BlogVisitor::class, 'blog_id');
    }

    function getVisitorCountAttribute()
    {
        return $this->visitors()->count();
    }


}
