<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    protected $appends = ['image_url'];

    protected $casts = [
      'screenshots' => 'array'
    ];

    function serviceType()
    {
        return $this->belongsTo(ServiceType::class);
    }

    function file()
    {
        return $this->belongsTo(File::class);
    }

    function getImageUrlAttribute()
    {
        return $this->file ? asset($this->file->path) : '';
    }

}
