<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->text('summary')->nullable();
            $table->text('challenge')->nullable();
            $table->text('result')->nullable();
            $table->text('screenshots')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->dropColumn('summary');
            $table->dropColumn('challenge');
            $table->dropColumn('result');
            $table->dropColumn('screenshots');
        });
    }
};
