/* eslint-disable import/order */
import '@/@iconify/icons-bundle'
import App from '@/App.vue'
import layoutsPlugin from '@/plugins/layouts'
import vuetify from '@/plugins/vuetify'
import { loadFonts } from '@/plugins/webfontloader'
import router from '@/router'
// eslint-disable-next-line import/no-unresolved
import '@core-scss/template/index.scss'
import '@styles/styles.scss'
import { createPinia } from 'pinia'
import { createApp } from 'vue'
import { vueAuth } from '@/plugins/auth'
import Toast from "vue-toastification"
import "vue-toastification/dist/index.css"
import { defineRule } from "vee-validate"
import { email, required, min, max, between, username, nameWithSpace, nameWithNumber } from "@/utils/validationRules"

loadFonts()


// Create vue app
const app = createApp(App)


// Use plugins
app.use(vuetify)
app.use(createPinia())
app.use(router)
app.use(layoutsPlugin)

app.use(vueAuth)

//Toaster default configuration

app.use(Toast, {
  position: "top-right",
  timeout: 5000,
  closeOnClick: true,
  pauseOnFocusLoss: true,
  pauseOnHover: false,
  draggable: false,
  draggablePercent: 0.6,
  showCloseButtonOnHover: false,
  hideProgressBar: true,
  closeButton: false,
  icon: true,
  rtl: false,
})

//validation rules
defineRule('required', required)
defineRule('email', email)
defineRule('username', username)
defineRule('min', min)
defineRule('max', max)
defineRule('name-with-space', nameWithSpace)
defineRule('name-with-number', nameWithNumber)

// Mount vue app
app.mount('#app')

