import authConfig from './config'

/* eslint-disable */

let auth = null
let axiosIns = null
let router = null

export function Auth(Vue, options) {
  auth = this
  axiosIns = options.axios
  router = options.router
  // eslint-disable-next-line no-use-before-define
  _initVm(Vue)
  _initInterceptor()
  _routeBeforeEach()
}

// eslint-disable-next-line no-underscore-dangle
function _initVm(Vue) {
  auth.$vm = new Vue({
    data: function () {
      return {
        state: {
          user: null,
          isLoaded: false,
        },
      }
    },
  })
}

function _initInterceptor() {

  axiosIns.interceptors.request.use((config) => {
    const accessToken = _getToken()

    // If token is present add it to request's Authorization Header
    if (accessToken) {
      // eslint-disable-next-line no-param-reassign
      config.headers.Authorization = `${authConfig.tokenType} ${accessToken}`
    }
    return config
  })

  axiosIns.interceptors.response.use(
    response => response, error => {
      let { response } = error

      if (response?.status === 401) {
        _processLogout()
      }

      return Promise.reject(error)

    })
}

function _routeBeforeEach() {
  router.beforeEach(async (to, from, next) => {

    if (!from.name) {
      //only fetch if request comes from browser
      await _fetchUser()
    }

    let user = _getUser()

    let meta = to.meta

    if (!meta.hasOwnProperty('auth') && meta.auth === null) {
      return next()
    } else if (meta.auth === false) {
      _checkAuth() ? next('/') : next()
    } else if (meta.auth === true) {
      _checkAuth() ? next() : next('/login')
    } else if (typeof meta.auth === 'object') {

      if (_checkAuth()) {

        let { permissions, roles } = meta.auth

        if (permissions || roles) {
          if (_userCan(permissions, roles)) {
            return next()
          } else {
            return next('/401')
          }
        }
      } else {
        return next('/login')
      }

    }

    return next()
  })
}

function _setUser(user) {
  auth.$vm.state.user = user
}

function _getUser() {
  return auth.$vm.state.user
}

Auth.prototype.setUser = _setUser

function _setLoaded(value) {
  auth.$vm.state.isLoaded = value
}

function _ready() {
  return auth.$vm.state.isLoaded
}

Auth.prototype.isReady = function () {
  return _ready()
}

function _fetchUser() {

  let token = _getToken()

  const user = _getUser()

  if (token && !user) {
    return new Promise((resolve, reject) => {
      axiosIns.get(authConfig.fetchUser)
        .then(res => {
          _setUser(res.data)
          resolve(res.data)
          _setLoaded(true)
        })
        .catch(er => {
          reject(er)
          _setLoaded(true)
        })
    })
  } else {
    _setLoaded(true)
  }
}

function _checkAuth() {
  return !!auth.$vm.state.user
}

Auth.prototype.fetchUser = _fetchUser

Auth.prototype.getUser = () => {
  return auth.$vm.state.user
}

Auth.prototype.isAuth = _checkAuth

function _getToken() {
  return localStorage.getItem(authConfig.tokenKey)
}

Auth.prototype.getToken = _getToken

function _setToken(value) {
  localStorage.setItem(authConfig.tokenKey, value)
}

Auth.prototype.setToken = _setToken

function _removeToken() {
  localStorage.removeItem(authConfig.tokenKey)
}

Auth.prototype.login = async (...args) => {

  let loginInfo = {
    status: '',
    message: '',
  }

  let res = await axiosIns.post(authConfig.loginEndPoint, ...args)

  let {
    accessToken,
    status,
    message,
  } = res.data

  if (status === 'success') {
    loginInfo.message = 'Login Successful'
    loginInfo.status = 'success'
    _setToken(accessToken)

    //fetch user

    await _fetchUser()

    if (authConfig.redirectAfterLogin) {
      router.push('/')
    }

  } else {
    loginInfo.message = message
    loginInfo.status = 'failed'
  }

  return loginInfo

}

function _processLogout() {
  _removeToken()
  auth.$vm.state.user = null
  if (window.location.pathname !== '/login') {
    router.push('/login')
  }
}

Auth.prototype.logout = async () => {

  let logoutInfo = {
    status: '',
    message: '',
  }

  let res = await axiosIns.post(authConfig.logoutEndpoint)

  let {
    status,
    message,
  } = res.data

  if (status === 'success') {
    logoutInfo = {
      ...logoutInfo,
      status,
      message,
    }
    _processLogout()
    router.push('/login')
  } else {
    logoutInfo = {
      ...logoutInfo,
      status,
      message,
    }
  }

  return logoutInfo

}

//checking roles and permissions

function _userCan(perms, reqRoles) {

  return true;

  let user = auth.$vm.state.user
  let superAdminRole = user[authConfig.superAdminRole]

  let permissions = user[authConfig.permKey]
  let roles = user[authConfig.roleKey] || []

  //
  if (roles) {

    if (typeof reqRoles === 'string') {
      //convert to array
      reqRoles = [reqRoles]
    }
    if (reqRoles.some(item => roles.includes(item))) {
      return true
    }

  }
  //else check for required permissions
  else {
    //perm is array
    if (typeof perms === 'string') {
      //convert to array
      perms = [perms]
    }
    if (perms.some(perm => permissions.includes(perm))) {
      return true
    }
  }

}

Auth.prototype.userCan = _userCan
