import { inject, reactive } from 'vue'
import { Auth } from "./auth"
import axiosIns from "@axios"
import router from "@/router"

const authKey = 'auth'

function Vue(obj) {
  const data = obj.data()

  this.state = reactive(data.state)
}

Auth.prototype.install = function (app, key) {
  app.provide(key || authKey, this)

  app.config.globalProperties.$auth = this
}

//

export function createAuth(options) {
  return new Auth(Vue, options)
}

export function useAuth(key) {
  return inject(key ? key : authKey)
}

export const vueAuth = app => app.use(createAuth({ axios: axiosIns, router }))
