//eslint-disable-next-line
import axios from 'axios'
import { showToast } from "@/utils/showToast"

const axiosIns = axios.create({
  baseURL: import.meta.env.VITE_APP_URL + '/api', accept: 'application/json',
})

axiosIns.interceptors.response.use(res => {
  return Promise.resolve(res)
}, error => {

  if (error.response) {
    showToast(error.response.data)
  } else {
    let message = error.message

    //console.log({ message })
    showToast(message, 'error')
  }

  return Promise.reject(error)
})

export default axiosIns
