export const routes = [
  {
    path: '/',
    name: 'index',
    // eslint-disable-next-line import/extensions
    component: () => import('@/pages/index.vue'),
    meta: {
      auth: true,
    },
  },

  {
    path: '/blogs/add',
    name: 'blogs.add',
    // eslint-disable-next-line import/extensions
    component: () => import('@/pages/blog/AddOrUpdatePage.vue'),
    meta: {
      auth: true,
    },
  },

  {
    path: '/blogs/:id/edit',
    name: 'blogs.edit',
    // eslint-disable-next-line import/extensions
    component: () => import('@/pages/blog/AddOrUpdatePage.vue'),
    meta: {
      auth: true,
    },
  },

  {
    path: '/blogs',
    name: 'blogs.index',
    // eslint-disable-next-line import/extensions
    component: () => import('@/pages/blog/index.vue'),
    meta: {
      auth: true,
    },
  },

  {
    path: '/projects/add',
    name: 'projects.add',
    // eslint-disable-next-line import/extensions
    component: () => import('@/pages/project/AddOrUpdatePage.vue'),
    meta: {
      auth: true,
    },
  },

  {
    path: '/projects/:id/edit',
    name: 'projects.edit',
    // eslint-disable-next-line import/extensions
    component: () => import('@/pages/project/AddOrUpdatePage.vue'),
    meta: {
      auth: true,
    },
  },

  {
    path: '/projects',
    name: 'projects.index',
    // eslint-disable-next-line import/extensions
    component: () => import('@/pages/project/index.vue'),
    meta: {
      auth: true,
    },
  },

  {
    path: '/blog-categories',
    name: 'blog-categories.index',
    // eslint-disable-next-line import/extensions
    component: () => import('@/pages/blog-category/index.vue'),
    meta: {
      auth: true,
    },
  },
  {
    path: '/service-types',
    name: 'service-types.index',
    // eslint-disable-next-line import/extensions
    component: () => import('@/pages/service-type/index.vue'),
    meta: {
      auth: true,
    },
  },
  {
    path: '/files',
    name: 'files.index',
    // eslint-disable-next-line import/extensions
    component: () => import('@/pages/files/index.vue'),
    meta: {
      auth: true,
    },
  },

  //Reports

  {
    path: '/login',
    name: 'login',
    component: () => import('@/pages/login.vue'),
    meta: {
      auth: false,
      layout: 'blank',
    },
  },
  {
    path: '/register',
    name: 'register',
    component: () => import('@/pages/register.vue'),
    meta: {
      auth: false,
      layout: 'blank',
    },
  },
  {
    path: '/401',
    component: () => import('@/pages/errors/Forbidden.vue'),
  },
  {
    path: '/:pathMatch(.*)*',
    component: () => import('@/pages/errors/NotFound.vue'),
  },
]
