import axiosIns from '@axios'

export const useBlogCategoryStore = defineStore('blog-category', {
  state: () => ({
    blogCategories: [],
    loading: false,
  }),
  actions: {
    async fetchBlogCategories(type = '') {
      //fetch data if no data or type is refresh
      if (!this.blogCategories.length || type === 'refresh') {
        this.loading = true
        let res = await axiosIns.get('/blog-categories')
        const data = res.data

        this.blogCategories = data.data
        this.loading = false
      }
    },
  },
})
