import { useToast } from "vue-toastification"

const showToast = (data, type='') => {

  let toastOptions = {}
  let toastMessage = ""
  if(typeof data === 'object'){
    const { status, message } = data

    toastMessage = message
    if(status === 'success'){
      toastOptions.type = 'success'
    }else{
      toastOptions.type = 'error'
    }
  }else{
    toastMessage = data
    if(type){
      toastOptions.type = type
    }
  }

  const toast = useToast()

  toast(toastMessage, toastOptions)
}

export { showToast }
