<?php

use App\Http\Controllers\Api\AuditorController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\BlogController;
use App\Http\Controllers\Api\BlogCategoryController;
use App\Http\Controllers\Api\IsoCertificationController;
use App\Http\Controllers\Api\PaymentController;
use App\Http\Controllers\Api\ProjectController;
use App\Http\Controllers\Api\ServiceTypeController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\CommonController;
use App\Http\Controllers\FileController;
use App\Http\Controllers\WebsiteController;
use Illuminate\Support\Facades\Route;

Route::post('/auth/login', [AuthController::class, 'login']);

Route::middleware('auth:sanctum')->group(function () {
    Route::post('/auth/logout', [AuthController::class, 'logout']);
    Route::get('/auth/user', [AuthController::class, 'getUser']);
    //expense types

    Route::get('/blog-categories', [BlogCategoryController::class, 'index']);
    Route::post('/blog-categories', [BlogCategoryController::class, 'store']);
    Route::delete('/blog-categories/{id}', [BlogCategoryController::class, 'destroy']);
    Route::put('/blog-categories/{id}/toggle-status', [BlogCategoryController::class , 'toggleStatus']);

    Route::get('/service-types', [ServiceTypeController::class, 'index']);
    Route::post('/service-types', [ServiceTypeController::class, 'store']);
    Route::delete('/service-types/{id}', [ServiceTypeController::class, 'destroy']);
    Route::put('/service-types/{id}/toggle-status', [ServiceTypeController::class , 'toggleStatus']);


    Route::get('/home-data', [CommonController::class, 'getHomeData']);

    Route::resource('/blogs', BlogController::class);

    Route::resource('/projects', ProjectController::class);

    Route::get('/get-dropdown-data', [CommonController::class, 'getDropdownData']);

    Route::get('/files', [FileController::class, 'index']);
    Route::post('/upload-file', [FileController::class, 'store']);

    Route::post('/delete-files', [FileController::class, 'destroy']);

});

Route::get('/web/blogs', [WebsiteController::class, 'blogs']);
Route::get('/web/blogs/{id}', [WebsiteController::class, 'blogDetails']);
Route::get('/web/related-blogs', [WebsiteController::class, 'relatedBlogs']);
Route::get('/web/categories', [WebsiteController::class, 'categories']);

Route::get('/web/services', [WebsiteController::class, 'services']);

Route::get('/web/projects/{id}', [WebsiteController::class, 'projectDetails']);
Route::get('/web/projects', [WebsiteController::class, 'projects']);
